/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.vw.api.VWException;
import filenet.vw.base.VWString;
import java.io.Serializable;

public final class VWScenarioDayType
implements Serializable {
    private static String m_strMon = "MON";
    private static String m_strTue = "TUE";
    private static String m_strWed = "WED";
    private static String m_strThur = "THU";
    private static String m_strFri = "FRI";
    private static String m_strSat = "SAT";
    private static String m_strSun = "SUN";
    public static final int DAY_TYPE_MONDAY = 1;
    public static final int DAY_TYPE_TUESDAY = 2;
    public static final int DAY_TYPE_WEDNESDAY = 4;
    public static final int DAY_TYPE_THURSDAY = 8;
    public static final int DAY_TYPE_FRIDAY = 16;
    public static final int DAY_TYPE_SATURDAY = 32;
    public static final int DAY_TYPE_SUNDAY = 64;
    private static String[] LocalizedStrings = new String[]{new VWString("sim.api.VWScenarioDayType.Monday", "Monday").toString(), new VWString("sim.api.VWScenarioDayType.Tuesday", "Tuesday").toString(), new VWString("sim.api.VWScenarioDayType.Wednesday", "Wednesday").toString(), new VWString("sim.api.VWScenarioDayType.Thursday", "Thursday").toString(), new VWString("sim.api.VWScenarioDayType.Friday", "Friday").toString(), new VWString("sim.api.VWScenarioDayType.Saturday", "Saturday").toString(), new VWString("sim.api.VWScenarioDayType.Sunday", "Sunday").toString()};

    public static String getLocalizedString(int theDayType) throws VWException {
        if (!VWScenarioDayType.isValid(theDayType)) {
            throw new VWException("sim.api.VWScenarioDayType.BadInteger", "Integer form of the day type is invalid: {0}", String.valueOf(theDayType));
        }
        return LocalizedStrings[VWScenarioDayType.twoPower(theDayType)];
    }

    public static boolean isValid(int theDayType) {
        return theDayType == 1 || theDayType == 2 || theDayType == 4 || theDayType == 8 || theDayType == 16 || theDayType == 32 || theDayType == 64;
    }

    protected static String typeToString(int theDayType) throws VWException {
        switch (theDayType) {
            case 1: {
                return m_strMon;
            }
            case 2: {
                return m_strTue;
            }
            case 4: {
                return m_strWed;
            }
            case 8: {
                return m_strThur;
            }
            case 16: {
                return m_strFri;
            }
            case 32: {
                return m_strSat;
            }
            case 64: {
                return m_strSun;
            }
        }
        throw new VWException("sim.api.VWScenarioDayType.BadInteger", "Integer form of the day type is invalid: {0}", String.valueOf(theDayType));
    }

    protected static int stringToType(String theDayType) throws VWException {
        if (theDayType.equals(m_strMon)) {
            return 1;
        }
        if (theDayType.equals(m_strTue)) {
            return 2;
        }
        if (theDayType.equals(m_strWed)) {
            return 4;
        }
        if (theDayType.equals(m_strThur)) {
            return 8;
        }
        if (theDayType.equals(m_strFri)) {
            return 16;
        }
        if (theDayType.equals(m_strSat)) {
            return 32;
        }
        if (theDayType.equals(m_strSun)) {
            return 64;
        }
        throw new VWException("sim.api.VWScenarioDayType.BadString", "The day type is invalid: {0}", theDayType);
    }

    private static int twoPower(int theDayType) {
        int type = theDayType;
        int exponent = 0;
        while ((type >>= 1) != 0) {
            ++exponent;
        }
        return exponent;
    }
}

